<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.transfer' => 'Transfer',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.share_via' => 'Share via %s',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose language',
    'global.choose_currency' => 'Choose currency',
    'global.theme_style' => 'Switch to %s (CMD/CTRL + I)',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available',
    'global.na' => 'N/A',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.status' => 'Status',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.all' => 'All',
    'global.order' => 'Order',
    'global.order_int_help' => 'Set a number to control the display position. Smaller numbers show first (ascending order).',
    'global.statistics' => 'Statistics',
    'global.download' => 'Download',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.remove_selected_file' => 'Remove selected file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device' => 'Device',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.continent' => 'Continent',
    'global.continents' => 'Continents',
    'global.country' => 'Country',
    'global.countries' => 'Countries',
    'global.city' => 'City',
    'global.cities' => 'Cities',
    'global.os_name' => 'Operating system',
    'global.browser_name' => 'Browser',
    'global.browser_language' => 'Browser language',
    'global.ip' => 'IP',
    'global.name' => 'Name',
    'global.description' => 'Description',
    'global.title' => 'Title',
    'global.email' => 'Email',
    'global.email_placeholder' => 'hello@example.com',
    'global.password' => 'Password',
    'global.user' => 'User',
    'global.image' => 'Image',
    'global.icon' => 'Icon',
    'global.icon_placeholder' => 'fas fa-bolt',
    'global.icon_help' => '<a href="https://fontawesome.com/search?o=r&m=free" target="_blank">FontAwesome</a> icon class.',
    'global.url' => 'URL',
    'global.url_placeholder' => 'https://example.com/',
    'global.url_slug_placeholder' => 'example',
    'global.host' => 'Host',
    'global.host_placeholder' => 'example.com',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.spintax_help' => 'You can also use Spintax format, as such: <code>{Hi|Hey|Hello}</code> to randomize words or phrases.',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',
    'global.update_x' => 'Edit %s',
    'global.mb' => 'MB',
    'global.details' => 'Details',
    'global.type' => 'Type',
    'global.view_all' => 'View all',
    'global.select_all' => 'Select all',
    'global.deselect_all' => 'Deselect all',
    'global.show' => 'Show',
    'global.hide' => 'Hide',
    'global.chart_help' => 'Chart automatically refreshes every %1$s hours. Data from the last %2$s days.',
    'global.id' => 'Entry number (ID)',
    'global.variables' => 'You can use the following dynamic variables: %s.',
    'global.translate' => 'Translate',
    'global.scroll_top' => 'Scroll top',
    'global.scroll_bottom' => 'Scroll bottom',
    'global.no_chart_data' => 'No data available',
    'global.no_chart_data_help' => 'There is not enough data to generate a chart.',
    'global.image_error' => 'Image error',
    'global.spotlight.search_placeholder' => '🔎 Search & go to a page...',
    'global.spotlight.tooltip' => 'Spotlight search (CMD/CTRL + K)',
    'global.drag_and_drop' => 'Drag & drop to reorder',
    'global.crop' => 'Crop image',
    'global.crop_selection' => 'Crop selection',
    'global.no_crop' => 'Continue without cropping',
    'global.prefilled_dynamic_name' => '%1$s %2$s - %3$s, %4$s',
    'global.day_part_late_night' => 'Late Night',
    'global.day_part_early_morning' => 'Early Morning',
    'global.day_part_morning' => 'Morning',
    'global.day_part_afternoon' => 'Afternoon',
    'global.day_part_evening' => 'Evening',
    'global.day_part_night' => 'Night',

    'global.custom_js' => 'Custom JS',
    'global.custom_js_help' => 'Your custom JS code to enhance the capability of your page.',
    'global.custom_js_placeholder' => '<script>console.log(`Hello world`);</script>',

    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_upgrade' => 'Upgrade your plan 🔐',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.plan_feature_limit_removal' => 'You must delete %1$s %2$s as you have exceeded your plan limits.',
    'global.info_message.plan_feature_limit_removal_with_upgrade' => 'You must delete %1$s %2$s or %3$s as you have exceeded your plan limits.',
    'global.info_message.plan_feature_limit_info' => '%1$s out of %2$s used <br /> %3$s remaining',
    'global.info_message.plan_feature_limit_month_info' => '%1$s out of %2$s used <br /> %3$s remaining this month',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',
    'global.info_message.admin_feature_disabled' => 'This feature is disabled from the <a href="%s" target="_blank">settings page</a>.',
    'global.info_message.admin_feature_partially_disabled' => 'This feature is partially disabled from the <a href="%s" target="_blank">settings page</a>.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the required fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',
    'global.error_message.limit_try_again' => 'You reached the limit. Try again in %1$s %2$s.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin panel',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',
    'global.accessibility.admin_file_size_limit_help' => 'You are not able to set a higher limit than your actual server upload limit.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.tooltip' => 'Filters<br />(CMD/CTRL + SHIFT + F)',
    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.clear' => 'Clear filters',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.results_per_page' => 'Results per page',
    'global.filters.no_data' => 'No filtered data found',
    'global.filters.no_data_help' => 'No matches found for your filter.',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.this_week' => 'This week',
    'global.date.last_week' => 'Last week',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.this_year' => 'This year',
    'global.date.last_year' => 'Last year',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',
    'global.emails.is_broadcast' => 'You are receiving this email because you have subscribed to our newsletter broadcasts. You can %sUnsubscribe here%s at any point in time.',

    'global.emails.user_welcome.subject' => 'Welcome to {{WEBSITE_TITLE}}',
    'global.emails.user_welcome.body' => 'Hello, <strong>{{NAME}}</strong>!<br /><br />Welcome to our website community, we\'re excited to have you on board!<br /><br />Get started by visiting our <a href="{{URL}}">homepage</a> or your <a href="{{DASHBOARD_LINK}}">dashboard</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and your account is ready,<br /><br />Click the link below in order to join <strong>{{WEBSITE_TITLE}}</strong><br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Activate account</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Confirm email address change</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is your reset password link:<br /><br /><a href="{{LOST_PASSWORD_LINK}}" class="cta">Reset password</a><br /><br />If you did not request this, you can ignore it.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />You\'ve paid for the <strong>{{PLAN_NAME}}</strong> plan until <strong>{{PLAN_EXPIRATION_DATE}}</strong>.<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple reminder that your <strong>{{PLAN_NAME}} plan</strong> is going to expire in <strong>{{DAYS_UNTIL_EXPIRATION}} days</strong>.<br /><br />You must renew your plan if you wish to continue using our website with all the features you have.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expired.subject' => 'Your plan has expired - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expired.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />Your <strong>{{PLAN_NAME}} plan</strong> has expired as you haven\'t renewed your membership.<br /><br />If you wish to continue using our website with all the features you had, you will need to renew your membership.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply login with your account and the deletion process will be stopped.<br /><br /><a href="{{LOGIN_LINK}}">Login & stop deletion</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to sign-up another account with us.<br /><br /><a href="{{REGISTER_LINK}}" class="cta">Register again</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM:NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}" class="cta">login and accept invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',
    'global.emails.team_member_create.body_register' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}" class="cta">register and accept invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) has signed up successfully.<br /><br /><strong>Source:</strong> {{SOURCE}}<br /><strong>IP:</strong> {{IP}}<br /><strong>Country:</strong> {{COUNTRY_NAME}}<br /><strong>City:</strong> {{CITY_NAME}}<br /><strong>Device:</strong> {{DEVICE_TYPE}}<br /><strong>OS:</strong> {{OS_NAME}}<br /><strong>Browser:</strong> {{BROWSER_NAME}}<br /><br /><a href="{{USER_LINK}}" class="cta">View user</a>',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.<br /><br /><strong>Account age:</strong> {{ACCOUNT_AGE}}<br /><strong>Source:</strong> {{SOURCE}}<br /><strong>IP:</strong> {{IP}}<br /><strong>Country:</strong> {{COUNTRY_NAME}}<br /><strong>City:</strong> {{CITY_NAME}}<br /><strong>Device:</strong> {{DEVICE_TYPE}}<br /><strong>OS:</strong> {{OS_NAME}}<br /><strong>Browser:</strong> {{BROWSER_NAME}}<br /><br />All of the data related to this user has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> for the <strong>{{PLAN_NAME}} plan</strong>.<br /><br /><strong>Type:</strong> {{PAYMENT_TYPE}}<br /><strong>Frequency:</strong> {{PAYMENT_FREQUENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Code:</strong> {{CODE}} {{CODE_DETAILS}}<br /><strong>Payment ID:</strong> {{PAYMENT_ID}}<br /><strong>Processor payment ID:</strong> {{EXTERNAL_PAYMENT_ID}}<br /><strong>Status:</strong> {{PAYMENT_STATUS}}<br /><strong>Date:</strong> {{DATE}} {{DATE_TIMEZONE}}<br /><br /><a href="{{PAYMENT_LINK}}" class="cta">View payment</a>',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}" class="cta">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}" class="cta">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) has sent you the following message:<br /><br />{{MESSAGE}}',


    'global.notifications.new_user.title' => 'New user!',
    'global.notifications.new_user.description' => '<strong>%1$s</strong> (%2$s) has signed up successfully.',

    'global.notifications.delete_user.title' => 'User deleted!',
    'global.notifications.delete_user.description' => '<strong>%1$s</strong> (%2$s) has deleted his account.',

    'global.notifications.new_payment.title' => 'New payment!',
    'global.notifications.new_payment.description' => '<strong>%1$s</strong> (%2$s) user just paid <strong>%3$s %4$s</strong> via %5$s.',

    'global.notifications.new_affiliate_withdrawal.title' => 'New affiliate withdrawal request!',
    'global.notifications.new_affiliate_withdrawal.description' => '<strong>%1$s</strong> (%2$s) user just submitted an affiliate withdrawal request for <strong>%3$s %4$s</strong>.',

    'global.notifications.new_newsletter_subscriber.title' => 'New newsletter subscriber!',
    'global.notifications.new_newsletter_subscriber.description' => '<strong>%1$s</strong> (%2$s) has subscribed successfully.',


    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent.',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.customize' => 'Customize',
    'global.cookie_consent.save' => 'Save settings',

    'global.footer.copyright' => 'Copyright &copy; %1$s %2$s.',

    'global.plan_settings.price_savings' => '%s%% off',
    'global.plan_settings.quarterly_price_savings' => 'You save %s by purchasing the quarterly plan',
    'global.plan_settings.biannual_price_savings' => 'You save %s by purchasing the biannual plan',
    'global.plan_settings.annual_price_savings' => 'You save %s by purchasing the annual plan',
    'global.plan_settings.ai_qr_codes_per_month_limit' => '%s AI QR codes <span class="small text-muted">/ month</span>',
    'global.plan_settings.enabled_qr_codes' => '%s QR code types',
    'global.plan_settings.qr_codes_limit' => '%s saved QR codes',
    'global.plan_settings.qr_codes_bulk_limit' => '%s Bulk QR codes limit',
    'global.plan_settings.enabled_barcodes' => '%s barcodes types',
    'global.plan_settings.barcodes_limit' => '%s saved barcodes',
    'global.plan_settings.barcodes_bulk_limit' => '%s Bulk barcodes limit',
    'global.plan_settings.links_limit' => '%s dynamic links',
    'global.plan_settings.links_bulk_limit' => '%s bulk links',
    'global.plan_settings.pixels_limit' => '%s pixels',
    'global.plan_settings.projects_limit' => '%s projects',
    'global.plan_settings.domains_limit' => '%s custom domains',
    'global.plan_settings.statistics_retention' => '%s stats retention',
    'global.plan_settings.additional_domains' => '%s additional domains',
    'global.plan_settings.additional_domains_help' => 'You get to choose from multiple domains when creating a dynamic QR code link. %s',
    'global.plan_settings.password_protection_is_enabled' => 'Password protection',
    'global.plan_settings.password_protection_is_enabled_help' => 'Your QR code links can be password protected if needed.',
    'global.plan_settings.sensitive_content_is_enabled' => 'Sensitive content',
    'global.plan_settings.sensitive_content_is_enabled_help' => 'Your QR code links can display a sensitive content warning if needed.',
    'global.plan_settings.cloaking_is_enabled' => 'Cloaking short URLs',
    'global.plan_settings.cloaking_is_enabled_help' => 'The ability to hide the original destination URL of a short link, under the created short alias.',
    'global.plan_settings.app_linking_is_enabled' => 'Auto open app on mobile',
    'global.plan_settings.app_linking_is_enabled_help' => 'The ability to automatically detect and open the specific apps on mobile for short URLs.',
    'global.plan_settings.targeting_is_enabled' => 'Advanced targeting',
    'global.plan_settings.targeting_is_enabled_help' => 'The ability to use the short URLs targeting features: Continent, Country, City, Device, OS, Browser, Language, A/B testing.',
    'global.plan_settings.analytics_is_enabled' => 'Included analytics',
    'global.plan_settings.analytics_is_enabled_help' => 'Great QR code links analytics to see how many visitors you get.',
    'global.plan_settings.custom_url_is_enabled' => 'Custom back-half URL',
    'global.plan_settings.custom_url_is_enabled_help' => 'You will be able to choose a custom URL when creating a dynamic QR code link.',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.white_labeling_is_enabled' => 'White labeling',
    'global.plan_settings.white_labeling_is_enabled_help' => 'White label your whole account title, logo, favicon and footer.',
    'global.plan_settings.affiliate_commission_percentage' => '%s affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.no_ads' => 'No ads',
    'global.plan_settings.no_ads_help' => 'No ads for everything related to your account and experience.',
    'global.plan_settings.export' => '%s export features',
    'global.plan_settings.removable_branding' => 'Removable branding',
    'global.plan_settings.removable_branding_help' => 'All the branding will be removed from branded resources.',
    'global.plan_settings.qr_reader_is_enabled' => 'QR Reader',
    'global.plan_settings.qr_reader_is_enabled_help' => 'Get access to the QR reader functionality.',
    'global.plan_settings.barcode_reader_is_enabled' => 'Barcode Reader',
    'global.plan_settings.barcode_reader_is_enabled_help' => 'Get access to the barcode reader functionality.',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',
    'global.plan_settings.utm_parameters_is_enabled' => 'UTM Parameters',
    'global.plan_settings.utm_parameters_is_enabled_help' => 'The ability to use the UTM parameters builder for your links.',

    'pwa_install.header' => 'Install our app 🪄',
    'pwa_install.or' => 'or',
    'pwa_install.subheader.desktop' => 'click on the <code>%s</code> icon in the top right of the address bar.',
    'pwa_install.subheader.android_chrome' => 'tap on the <code>%s</code> menu and then tap the <code>%s Add to Home screen</code> menu item.',
    'pwa_install.subheader.ios' => 'tap on the <code>%s</code> icon and then tap the <code>%s Add to Home Screen</code> menu item.',
    'pwa_install.subheader.ios_safari' => 'click on the <code>File > Add to Dock</code> menu item of the browser.',


    'push_notifications_modal.menu' => 'Push notifications',
    'push_notifications_modal.header' => 'Push notifications',
    'push_notifications_modal.subheader' => 'You can subscribe to our web push notifications if you want to receive helpful content and non-spam promotions from us.',
    'push_notifications_modal.subscribe' => 'Subscribe',
    'push_notifications_modal.unsubscribe' => 'Unsubscribe',
    'push_notifications_modal.denied' => 'You have denied or disabled push notifications. You must enable them again from the browser settings in order to be able to subscribe.',
    'push_notifications_modal.incompatible' => 'Your browser window is incompatible with receiving push notifications.',


    'ad_blocker_detector_modal.header' => 'Ad blocker detected',
    'ad_blocker_detector_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'ad_blocker_detector_modal.button' => 'I\'ve disabled the ad blocker',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'transfer_modal.header' => 'Transfer ownership',
    'transfer_modal.subheader1' => 'Transfer <strong>%s</strong> to another user account.',
    'transfer_modal.subheader2' => 'Transfer this resource to another user account.',
    'transfer_modal.success_message' => 'The ownership of %1$s has been transferred from %2$s to %3$s',


    'statistics_reset_modal.header' => 'Clear statistics',
    'statistics_reset_modal.subheader' => 'Clear the current selected statistics. This action cannot be undone.',

    'x_reset_modal.header' => 'Reset',
    'x_reset_modal.subheader' => 'Reset the state of the resource and clear all it\'s associated logs or statistics. This action cannot be undone.',


    'bulk_download_modal.header' => 'Download in bulk',
    'bulk_download_modal.subheader' => 'You\'ve selected multiple entries to be downloaded, this may take a while for the ZIP to be generated.',


    'bulk_delete_modal.header' => 'Delete in bulk',
    'bulk_delete_modal.subheader' => 'You\'ve selected multiple entries for deletion. This may take a while and cannot be undone.',
    'bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',


    'l_link.password.title' => 'Password protected link',
    'l_link.password.header' => 'Password protected link',
    'l_link.password.subheader' => 'You must input the correct password to continue. Your password will be remembered for 30 days.',
    'l_link.password.error_message' => 'The password is incorrect.',


    'l_link.sensitive_content.title' => 'Sensitive content',
    'l_link.sensitive_content.header' => 'Sensitive content',
    'l_link.sensitive_content.subheader' => 'This link may contain sensitive content which some viewers may find offensive or disturbing.',
    'l_link.sensitive_content.button' => 'Accept',


    'qr.title' => 'QR code generator',
    'qr.menu' => 'Generate QR code',
    'qr.header' => 'QR code generator',
    'qr.subheader' => 'Generate easy & customizable QR codes in seconds.',
    'qr.title_dynamic' => '%1$s QR code generator',
    'qr.header_dynamic' => '%1$s QR code generator',
    'qr.subheader_dynamic' => 'Generate easy & customizable %1$s QR codes in seconds.',
    'qr.register' => 'Sign up to save it',
    'qr.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',


    'qr_reader.title' => 'QR code reader',
    'qr_reader.menu' => 'QR reader',
    'qr_reader.header' => 'QR code reader',
    'qr_reader.subheader' => 'Read already existing QR codes from image files.',
    'qr_reader.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',
    'qr_reader.result' => 'Data',
    'qr_reader.start_camera' => 'Start camera scanning',
    'qr_reader.stop_camera' => 'Stop camera',
    'qr_reader.camera_error_message' => 'No camera devices available.',


    'barcode.title' => 'Barcode generator',
    'barcode.menu' => 'Generate barcode',
    'barcode.header' => 'Barcode generator',
    'barcode.subheader' => 'Generate & customize barcodes with ease in seconds.',
    'barcode.title_dynamic' => '%1$s Barcode generator',
    'barcode.header_dynamic' => '%1$s Barcode generator',
    'barcode.subheader_dynamic' => 'Generate easy & customizable %1$s Barcodes in seconds.',
    'barcode.register' => 'Sign up to save it',
    'barcode.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',


    'barcode_reader.title' => 'Barcode reader',
    'barcode_reader.menu' => 'Barcode reader',
    'barcode_reader.header' => 'Barcode reader',
    'barcode_reader.subheader' => 'Scan and read existing barcodes from image files.',
    'barcode_reader.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',


    'ai_qr.title' => 'AI QR code generator',
    'ai_qr.menu' => 'Generate AI QR code',
    'ai_qr.header' => 'AI QR code generator',
    'ai_qr.subheader' => 'Generate beautiful AI art with QR code embedded with ease.',
    'ai_qr.register' => 'Sign up to save it',
    'ai_qr.extra_content' => 'Change me from the language manager in the admin panel. You can add extra helpful content here.',


    'ai_qr_codes.title' => 'AI QR codes',
    'ai_qr_codes.menu' => 'AI QR codes',
    'ai_qr_codes.breadcrumb' => 'AI QR codes',
    'ai_qr_codes.header' => 'AI QR codes',
    'ai_qr_codes.subheader' => 'Generate stunning & functional AI QR codes in seconds.',
    'ai_qr_codes.create' => 'Create QR',
    'ai_qr_codes.print' => 'Print',
    'ai_qr_codes.content' => 'Text or URL',
    'ai_qr_codes.prompt' => 'Prompt',
    'ai_qr_codes.prompt_placeholder' => 'Nature scenery at sunset, waterfall, wild animals and sunshine rays',
    'ai_qr_codes.is_readable' => 'QR Code seems to be readable.',
    'ai_qr_codes.is_not_readable' => 'QR Code might not be readable. Check it with your scanner and regenerate if needed.',
    'ai_qr_codes.info' => 'Test out the QR code with a scanner before using it in production.',
    'ai_qr_codes.embedded_data' => 'Embedded data',
    'ai_qr_codes.error_message.api' => 'There was an issue with the generation of your AI QR code.',


    'ai_qr_code_create.breadcrumb' => 'Create AI QR code',
    'ai_qr_code_create.title' => 'Create AI QR code',
    'ai_qr_code_create.header' => 'Create AI QR code',
    'ai_qr_code_create.generate' => 'Generate AI QR code',
    'ai_qr_code_create.save' => 'Save',


    'ai_qr_code_update.breadcrumb' => 'Edit AI QR code',
    'ai_qr_code_update.title' => 'Edit AI QR code',
    'ai_qr_code_update.header' => 'Edit AI QR code',


    'qr_codes.title' => 'QR codes',
    'qr_codes.menu' => 'QR codes',
    'qr_codes.breadcrumb' => 'QR codes',
    'qr_codes.header' => 'QR codes',
    'qr_codes.subheader' => 'Easily create customizable QR codes & remember them for later use.',
    'qr_codes.create' => 'Create QR',
    'qr_codes.print' => 'Print',
    'qr_codes.qr_code' => 'QR code',
    'qr_codes.is_readable' => 'QR Code seems to be readable.',
    'qr_codes.is_not_readable' => 'QR Code might not be readable. Adjust your QR code settings or content.',
    'qr_codes.info' => 'Test out the QR code with a scanner before using it in production.',
    'qr_codes.embedded_data' => 'Embedded data',

    'qr_codes.type.text' => 'Text',
    'qr_codes.type.text_description' => 'Embed your custom text or format into a QR code with ease.',
    'qr_codes.type.text_extra_content' => '',
    'qr_codes.type.text_meta_keywords' => '',
    'qr_codes.type.url' => 'URL',
    'qr_codes.type.url_description' => 'Want someone to open your link? Add your link to a QR code.',
    'qr_codes.type.url_extra_content' => '',
    'qr_codes.type.url_meta_keywords' => '',
    'qr_codes.type.phone' => 'Phone',
    'qr_codes.type.phone_description' => 'Get calls from people by scanning your generated QR code.',
    'qr_codes.type.phone_extra_content' => '',
    'qr_codes.type.phone_meta_keywords' => '',
    'qr_codes.type.sms' => 'SMS',
    'qr_codes.type.sms_description' => 'Get custom SMS messages from people by scanning the QR code.',
    'qr_codes.type.sms_extra_content' => '',
    'qr_codes.type.sms_meta_keywords' => '',
    'qr_codes.type.email' => 'Email',
    'qr_codes.type.email_description' => 'Get custom Emails from people by scanning the QR code.',
    'qr_codes.type.email_extra_content' => '',
    'qr_codes.type.email_meta_keywords' => '',
    'qr_codes.type.whatsapp' => 'Whatsapp',
    'qr_codes.type.whatsapp_description' => 'Get custom Whatsapp messages from people by scanning the QR code.',
    'qr_codes.type.whatsapp_extra_content' => '',
    'qr_codes.type.whatsapp_meta_keywords' => '',
    'qr_codes.type.facetime' => 'Facetime',
    'qr_codes.type.facetime_description' => 'Get Facetime calls from people by scanning the QR code.',
    'qr_codes.type.facetime_extra_content' => '',
    'qr_codes.type.facetime_meta_keywords' => '',
    'qr_codes.type.location' => 'Location',
    'qr_codes.type.location_description' => 'Embed location coordinates for people to get directions more easily.',
    'qr_codes.type.location_extra_content' => '',
    'qr_codes.type.location_meta_keywords' => '',
    'qr_codes.type.wifi' => 'WiFi',
    'qr_codes.type.wifi_description' => 'Create WiFi QR codes and let people connect to your WiFi more easily.',
    'qr_codes.type.wifi_extra_content' => '',
    'qr_codes.type.wifi_meta_keywords' => '',
    'qr_codes.type.event' => 'Event',
    'qr_codes.type.event_description' => 'Generate a custom life calendar event and embed it into a QR code.',
    'qr_codes.type.event_extra_content' => '',
    'qr_codes.type.event_meta_keywords' => '',
    'qr_codes.type.crypto' => 'Crypto',
    'qr_codes.type.crypto_description' => 'Get paid in crypto from people by scanning the QR code.',
    'qr_codes.type.crypto_extra_content' => '',
    'qr_codes.type.crypto_meta_keywords' => '',
    'qr_codes.type.vcard' => 'Vcard',
    'qr_codes.type.vcard_description' => 'Embed all your contact data into a digital business card.',
    'qr_codes.type.vcard_extra_content' => '',
    'qr_codes.type.vcard_meta_keywords' => '',
    'qr_codes.type.paypal' => 'PayPal',
    'qr_codes.type.paypal_description' => 'Create PayPal direct payment links so you can easily get paid with a QR code.',
    'qr_codes.type.paypal_extra_content' => '',
    'qr_codes.type.paypal_meta_keywords' => '',
    'qr_codes.type.upi' => 'UPI Payment',
    'qr_codes.type.upi_description' => 'Create UPI (Unified Payment Interface) direct payment QR codes.',
    'qr_codes.type.upi_extra_content' => '',
    'qr_codes.type.upi_meta_keywords' => '',
    'qr_codes.type.epc' => 'EPC Payment',
    'qr_codes.type.epc_description' => 'Create EPC (European Payments Council) direct payment QR codes.',
    'qr_codes.type.epc_extra_content' => '',
    'qr_codes.type.epc_meta_keywords' => '',
    'qr_codes.type.pix' => 'PIX Payment',
    'qr_codes.type.pix_description' => 'Create PIX (Brazil) direct payment QR codes.',
    'qr_codes.type.pix_extra_content' => '',
    'qr_codes.type.pix_meta_keywords' => '',

    'qr_codes.input.type' => 'QR Type',
    'qr_codes.input.text' => 'Text content',
    'qr_codes.input.url_dynamic' => 'Dynamic QR code',
    'qr_codes.input.url_dynamic_help' => 'Enabling this will create a QR code that points to an internal short link, which will redirect to any specified link, dynamically.',
    'qr_codes.input.link_id' => 'URL',
    'qr_codes.input.phone' => 'Phone number',
    'qr_codes.input.sms' => 'Phone number',
    'qr_codes.input.sms_body' => 'Prefilled message',
    'qr_codes.input.email' => 'Email address',
    'qr_codes.input.email_subject' => 'Prefilled subject',
    'qr_codes.input.email_body' => 'Prefilled message',
    'qr_codes.input.whatsapp' => 'Phone number',
    'qr_codes.input.whatsapp_body' => 'Prefilled message',
    'qr_codes.input.facetime' => 'Phone number or email address',
    'qr_codes.input.location_latitude' => 'Latitude',
    'qr_codes.input.location_longitude' => 'Longitude',
    'qr_codes.input.wifi_ssid' => 'WiFi name (SSID)',
    'qr_codes.input.wifi_encryption' => 'Encryption',
    'qr_codes.input.wifi_encryption_nopass' => 'No encryption',
    'qr_codes.input.wifi_password' => 'Password',
    'qr_codes.input.wifi_is_hidden' => 'WiFi is hidden',
    'qr_codes.input.event' => 'Event name',
    'qr_codes.input.event_location' => 'GEO Location',
    'qr_codes.input.event_start_datetime' => 'Event starts on',
    'qr_codes.input.event_end_datetime' => 'Event ends on',
    'qr_codes.input.event_first_alert_datetime' => 'First alert reminder',
    'qr_codes.input.event_second_alert_datetime' => 'Second alert reminder',
    'qr_codes.input.event_timezone' => 'Timezone',
    'qr_codes.input.event_url' => 'Event URL',
    'qr_codes.input.event_note' => 'Notes',
    'qr_codes.input.crypto' => 'Crypto',
    'qr_codes.input.crypto_coin' => 'Coin',
    'qr_codes.input.crypto_address' => 'Address',
    'qr_codes.input.crypto_amount' => 'Amount',
    'qr_codes.input.vcard_first_name' => 'First name',
    'qr_codes.input.vcard_last_name' => 'Last name',
    'qr_codes.input.vcard_email' => 'Email',
    'qr_codes.input.vcard_url' => 'Website URL',
    'qr_codes.input.vcard_company' => 'Company',
    'qr_codes.input.vcard_job_title' => 'Job title',
    'qr_codes.input.vcard_birthday' => 'Birthday',
    'qr_codes.input.vcard_street' => 'Street address',
    'qr_codes.input.vcard_zip' => 'ZIP',
    'qr_codes.input.vcard_region' => 'Region',
    'qr_codes.input.vcard_note' => 'Note',
    'qr_codes.input.vcard_phone_numbers' => 'Phone numbers',
    'qr_codes.input.vcard_phone_number_value' => 'Phone number',
    'qr_codes.input.vcard_phone_number_label' => 'Label',
    'qr_codes.input.vcard_phone_number_label_help' => 'Leave empty to use the default phone generated label. Custom labels do not work on Android devices.',
    'qr_codes.input.vcard_socials' => 'Socials',
    'qr_codes.input.vcard_social_label' => 'Label',
    'qr_codes.input.vcard_social_value' => 'URL',
    'qr_codes.input.paypal_type' => 'Type',
    'qr_codes.input.paypal_type_buy_now' => 'Buy now',
    'qr_codes.input.paypal_type_add_to_cart' => 'Add to cart',
    'qr_codes.input.paypal_type_donation' => 'Donation',
    'qr_codes.input.paypal_email' => 'PayPal email',
    'qr_codes.input.paypal_title' => 'Product title',
    'qr_codes.input.paypal_currency' => 'Currency code',
    'qr_codes.input.paypal_price' => 'Price',
    'qr_codes.input.paypal_thank_you_url' => 'Thank you URL',
    'qr_codes.input.paypal_cancel_url' => 'Cancel URL',
    'qr_codes.input.upi_payee_id' => 'UPI ID / VPA',
    'qr_codes.input.upi_payee_name' => 'Payee name',
    'qr_codes.input.upi_amount' => 'Amount',
    'qr_codes.input.upi_currency' => 'Currency code',
    'qr_codes.input.upi_transaction_id' => 'Transaction ID',
    'qr_codes.input.upi_transaction_reference' => 'Transaction reference',
    'qr_codes.input.upi_transaction_note' => 'Transaction note',
    'qr_codes.input.upi_thank_you_url' => 'Thank you URL',
    'qr_codes.input.epc_payee_name' => 'Payee name',
    'qr_codes.input.epc_iban' => 'IBAN',
    'qr_codes.input.epc_bic' => 'BIC',
    'qr_codes.input.epc_amount' => 'Amount',
    'qr_codes.input.epc_currency' => 'Currency code',
    'qr_codes.input.epc_remittance_reference' => 'Remittance reference',
    'qr_codes.input.epc_information' => 'Information',
    'qr_codes.input.epc_remittance_text' => 'Remittance text',
    'qr_codes.input.pix_payee_key' => 'Pix key',
    'qr_codes.input.pix_payee_key_help' => 'Your CPF, CNPJ, Email, Phone or a Random key.',
    'qr_codes.input.pix_payee_name' => 'Payee name',
    'qr_codes.input.pix_city' => 'City',
    'qr_codes.input.pix_description' => 'Description',
    'qr_codes.input.pix_transaction_id' => 'Transaction ID',
    'qr_codes.input.pix_amount' => 'Amount',
    'qr_codes.input.pix_currency' => 'Currency code',

    'qr_codes.input.colors' => 'Colors',
    'qr_codes.input.style' => 'Style',
    'qr_codes.input.style.square' => 'Square',
    'qr_codes.input.style.dot' => 'Dot',
    'qr_codes.input.style.circle' => 'Circle',
    'qr_codes.input.style.round' => 'Rounded blob',
    'qr_codes.input.style.rounded' => 'Rounded',
    'qr_codes.input.style.heart' => 'Heart',
    'qr_codes.input.style.diamond' => 'Diamond',
    'qr_codes.input.style.star' => 'Star',
    'qr_codes.input.style.triangle' => 'Triangle',
    'qr_codes.input.style.hexagon' => 'Hexagon',
    'qr_codes.input.style.spaced_square' => 'Hexagon',
    'qr_codes.input.style.randomized_square' => 'Randomized square',
    'qr_codes.input.style.octagon' => 'Octagon',
    'qr_codes.input.style.shield' => 'Shield',
    'qr_codes.input.style.thick_star' => 'Thick star',
    'qr_codes.input.style.elastic_square' => 'Elastic square',
    'qr_codes.input.style.cross_x' => 'Cross X',
    'qr_codes.input.style.curvy_x' => 'Curvy X',
    'qr_codes.input.style.bold_x' => 'Bold X',
    'qr_codes.input.style.ninja' => 'Ninja',
    'qr_codes.input.style.sun' => 'Sun',
    'qr_codes.input.style.shine' => 'Shine',
    'qr_codes.input.style.bold_plus' => 'Bold plus',
    'qr_codes.input.style.inverted_squircle' => 'Inverted squircle',
    'qr_codes.input.style.teardrop' => 'Teardrop',
    'qr_codes.input.style.rounded_cross' => 'Rounded cross',
    'qr_codes.input.style.corner_cut' => 'Corner cut',
    'qr_codes.input.style.leaf' => 'Leaf',
    'qr_codes.input.style.flower' => 'Flower',
    'qr_codes.input.inner_eye_style' => 'Inner eye style',
    'qr_codes.input.outer_eye_style' => 'Outer eye style',
    'qr_codes.input.foreground_type' => 'Foreground type',
    'qr_codes.input.foreground_type_color' => 'Color',
    'qr_codes.input.foreground_type_gradient' => 'Gradient',
    'qr_codes.input.foreground_color' => 'Foreground color',
    'qr_codes.input.foreground_gradient_style' => 'Foreground gradient style',
    'qr_codes.input.foreground_gradient_style_vertical' => 'Vertical',
    'qr_codes.input.foreground_gradient_style_horizontal' => 'Horizontal',
    'qr_codes.input.foreground_gradient_style_diagonal' => 'Diagonal',
    'qr_codes.input.foreground_gradient_style_inverse_diagonal' => 'Inverse diagonal',
    'qr_codes.input.foreground_gradient_style_radial' => 'Radial',
    'qr_codes.input.foreground_gradient_one' => 'Foreground first color',
    'qr_codes.input.foreground_gradient_two' => 'Foreground second color',
    'qr_codes.input.background_color' => 'Background color',
    'qr_codes.input.background_color_transparency' => 'Background color transparency',
    'qr_codes.input.custom_eyes_color' => 'Custom eyes color',
    'qr_codes.input.eyes_inner_color' => 'Eyes inner color',
    'qr_codes.input.eyes_outer_color' => 'Eyes outer color',
    'qr_codes.input.branding' => 'Branding',
    'qr_codes.input.qr_code_logo' => 'Logo',
    'qr_codes.input.qr_code_logo_size' => 'Logo size',
    'qr_codes.input.qr_code_background' => 'Background image',
    'qr_codes.input.qr_code_background_help' => 'Only use the recommended 1:1 ratio for the image to look good.',
    'qr_codes.input.qr_code_background_transparency' => 'Background image transparency',
    'qr_codes.input.qr_code_foreground' => 'Foreground image',
    'qr_codes.input.qr_code_foreground_help' => 'Only use the recommended 1:1 ratio for the image to look good.',
    'qr_codes.input.qr_code_foreground_transparency' => 'Foreground image transparency',
    'qr_codes.input.options' => 'Options',
    'qr_codes.input.size' => 'Size',
    'qr_codes.input.margin' => 'Margin size',
    'qr_codes.input.ecc' => 'Error correction capability',
    'qr_codes.input.ecc_l' => 'L - low (7%)',
    'qr_codes.input.ecc_m' => 'M - medium (15%)',
    'qr_codes.input.ecc_q' => 'Q - high (25%)',
    'qr_codes.input.ecc_h' => 'H - best (30%)',
    'qr_codes.input.encoding' => 'Encoding',
    'qr_codes.input.frame' => 'Frame',
    'qr_codes.input.frame_text' => 'Frame text',
    'qr_codes.input.frame_text_size' => 'Frame text size',
    'qr_codes.input.frame_text_font' => 'Frame text font',
    'qr_codes.input.frame_custom_colors' => 'Apply custom colors',
    'qr_codes.input.frame_text_color' => 'Frame text color',
    'qr_codes.input.frame_color' => 'Frame color',
    'qr_codes.input.is_bulk' => 'Bulk generation',
    'qr_codes.input.is_bulk_help' => 'One per line. Maximum %s lines at a time.',
    'qr_codes.no_data' => 'No existing QR codes',
    'qr_codes.no_data_help' => 'Start by creating your QR code.',
    'qr_codes.empty_error_message' => 'Make sure to fill the QR content related fields.',


    'qr_code_create.breadcrumb' => 'Create QR code',
    'qr_code_create.title' => 'Create QR code',
    'qr_code_create.header' => 'Create QR code',


    'qr_code_update.breadcrumb' => 'Edit QR code',
    'qr_code_update.title' => 'Edit QR code',
    'qr_code_update.header' => 'Edit QR code',


    'barcodes.title' => 'Barcodes',
    'barcodes.menu' => 'Barcodes',
    'barcodes.breadcrumb' => 'Barcodes',
    'barcodes.header' => 'Barcodes',
    'barcodes.subheader' => 'Easily create customizable barcodes & remember them for later use.',
    'barcodes.create' => 'Create barcode',
    'barcodes.print' => 'Print',
    'barcodes.info' => 'Make sure to test out your configured barcode before using it in production.',
    'barcodes.embedded_data' => 'Embedded data',
    'barcodes.input.type' => 'Barcode type',
    'barcodes.input.value' => 'Value',
    'barcodes.input.display_text' => 'Display text value',
    'barcodes.input.colors' => 'Colors',
    'barcodes.input.foreground_color' => 'Foreground color',
    'barcodes.input.background_color' => 'Background color',
    'barcodes.input.options' => 'Options',
    'barcodes.input.width_scale' => 'Width scale',
    'barcodes.input.height' => 'Height',
    'barcodes.input.is_bulk' => 'Bulk generation',
    'barcodes.input.is_bulk_help' => 'One per line. Maximum %s lines at a time.',
    'barcodes.no_data' => 'No existing barcodes',
    'barcodes.no_data_help' => 'Start by creating your barcode.',
    'barcodes.invalid_error_message' => 'The value you entered is not supported.',


    'barcode_create.breadcrumb' => 'Create barcode',
    'barcode_create.title' => 'Create barcode',
    'barcode_create.header' => 'Create barcode',


    'barcode_update.breadcrumb' => 'Edit barcode',
    'barcode_update.title' => 'Edit barcode',
    'barcode_update.header' => 'Edit barcode',


    'links.breadcrumb' => 'Links',
    'links.title' => 'Links',
    'links.menu' => 'Links',
    'links.create' => 'Create link',
    'links.header' => 'Links',
    'links.subheader' => 'Shortened links, dynamic, to easily manage dynamic QR codes.',

    'links.table.link_id' => 'Link',
    'links.table.stats' => 'Stats',

    'links.input.location_urls' => 'Destination URLs',
    'links.input.location_url' => 'Destination URL',
    'links.input.location_url_warning_linked_qr_code' => 'If you change the Destination URL, all your linked QR codes will redirect to the new URL.',
    'links.input.domain_id' => 'Domain',
    'links.input.url' => 'URL Alias',
    'links.input.url_warning_linked_qr_code' => 'If you change the URL Alias, all your printed linked QR codes will stop working.',
    'links.input.is_bulk' => 'Bulk generation',
    'links.input.is_bulk_help' => 'One destination URL per line. Maximum %s lines at a time.',
    'links.input.is_enabled' => 'Link is active',
    'links.input.temporary_url' => 'Temporary URL',
    'links.input.schedule' => 'Schedule',
    'links.input.schedule_help' => 'Set an exact date when the link will work.',
    'links.input.start_date' => 'Start date',
    'links.input.end_date' => 'End date',
    'links.input.pageviews_limit' => 'Pageviews limit',
    'links.input.pageviews_limit_help' => 'Only allow the link to work for a certain amount of pageviews.',
    'links.input.expiration_url' => 'Expiration URL',
    'links.input.expiration_url_help' => 'Visitors will be redirected to this URL after the main link expires.',
    'links.input.targeting' => 'Targeting',
    'links.input.targeting_type' => 'Targeting type',
    'links.input.targeting_type_continent_code_help' => 'Send visitors to different URLs based on their continent location.',
    'links.input.targeting_type_country_code_help' => 'Send visitors to different URLs based on their country location.',
    'links.input.targeting_type_city_name_placeholder' => 'Tokyo',
    'links.input.targeting_type_city_name_help' => 'Send visitors to different URLs based on their city location.',
    'links.input.targeting_type_device_type' => 'Device type',
    'links.input.targeting_type_device_type_help' => 'Send visitors to different URLs based on the device that they are using.',
    'links.input.targeting_type_browser_language' => 'Browser language',
    'links.input.targeting_type_browser_language_help' => 'Send visitors to different URLs based on their main browser language.',
    'links.input.targeting_type_browser_name' => 'Browser',
    'links.input.targeting_type_browser_name_help' => 'Send visitors to different URLs based on their browser.',
    'links.input.targeting_type_rotation' => 'Rotation & A/B Testing',
    'links.input.targeting_type_rotation_help' => 'Randomly & equally split the visits to multiple URLs. Helpful when running A/B tests for example.',
    'links.input.targeting_type_percentage' => 'Percentage chances',
    'links.input.targeting_type_os_name' => 'Operating system',
    'links.input.targeting_type_os_name_help' => 'Send visitors to different URLs based on the device operating system that they are using.',
    'links.input.pixels' => 'Pixels',
    'links.input.pixels_ids' => 'Pixels',
    'links.input.protection' => 'Protection',
    'links.input.password_help' => 'Require visitors to enter a password before accessing the link.',
    'links.input.sensitive_content' => 'Sensitive content warning',
    'links.input.sensitive_content_help' => 'Require users to confirm that they want to access your link and letting them know that the link might be sensitive.',
    'links.input.advanced' => 'Advanced',
    'links.input.forward_query_parameters_is_enabled' => 'Forward query parameters',
    'links.input.forward_query_parameters_is_enabled_help' => 'If your short URL is accessed with query parameters (ex: ?name=sample), append that to the destination URL automatically.',
    'links.input.http' => 'HTTP Status',
    'links.input.http_header_help' => 'The HTTP status code is only sent when the pixels and cloaking features are not used.',
    'links.input.http_status_code.301' => '301 Permanent redirect',
    'links.input.http_status_code.302' => '302 Temporary redirect',
    'links.input.http_status_code.307' => '307 Form submissions with temporary redirect',
    'links.input.http_status_code.308' => '308 Form submissions with permanent redirect',
    'links.input.cloaking' => 'Cloaking',
    'links.input.cloaking_is_enabled' => 'URL Cloaking',
    'links.input.cloaking_is_enabled_help' => 'Hide the original destination URL and display the current Short URL in the browser. This feature only works for websites that allow iframe embedding.',
    'links.input.cloaking_title' => 'Title of the cloaked page',
    'links.input.cloaking_meta_description' => 'Meta description of the cloaked page',
    'links.input.cloaking_favicon' => 'Favicon of the cloaked page',
    'links.input.cloaking_opengraph' => 'Opengraph of the cloaked page',
    'links.input.app_linking' => 'App linking',
    'links.input.app_linking_is_enabled' => 'Auto open app on mobile',
    'links.input.app_linking_is_enabled_help' => 'Enable this if you want your link to automatically open as an app when accessed on mobile.',
    'links.input.app_linking_supported_os' => 'Supported operating systems',
    'links.input.app_linking_supported_apps' => 'Supported apps',
    'links.input.app_linking_supported_apps_help' => 'If you do not find your app here, you can use the Targeting feature to redirect the user to your app with your custom deep link.',
    'links.input.app_linking_supported_apps.matched' => 'Matched',
    'links.input.app_linking_supported_apps.no_match' => 'Your destination URL is not matching any of the supported apps for automatic app opening.',
    'links.input.utm' => 'UTM Parameters',
    'links.input.utm_medium' => 'Medium',
    'links.input.utm_medium_placeholder' => 'ex: link, banner, email, social',
    'links.input.utm_campaign' => 'Campaign',
    'links.input.utm_campaign_placeholder' => 'ex: spring_sale_2024, black_friday',
    'links.input.utm_source' => 'Source',
    'links.input.utm_source_placeholder' => 'ex: newsletter, bing, google, youtube',
    'links.input.utm_preview' => 'UTM preview',
    'links.input.utm_preview_help' => 'This query parameter will be appended to your destination URL.',

    'links.error_message.url_exists' => 'This custom URL already exists.',
    'links.error_message.url_minimum_characters' => 'This custom URL is too small. Make sure it has at least %s characters.',
    'links.error_message.url_maximum_characters' => 'This custom URL is too big. Make sure it has maximum %s characters.',
    'links.error_message.blacklisted_url' => 'This custom URL is not available for usage.',
    'links.error_message.blacklisted_domain' => 'This domain is blacklisted.',
    'links.error_message.blacklisted_keyword' => 'This custom URL is blacklisted.',
    'links.error_message.blacklisted_location_url' => 'This URL has been blacklisted.',
    'links.error_message.invalid_url' => 'This URL is invalid.',
    'links.error_message.invalid_location_url' => 'Your entered URL has an invalid format. Maybe you\'re missing the https:// from the URL?',

    'links.filters.search_by_url' => 'URL Alias',
    'links.filters.order_by_url' => 'URL Alias',
    'links.filters.search_by_location_url' => 'Location URL',
    'links.filters.order_by_location_url' => 'Location URL',
    'links.filters.order_by_pageviews' => 'Pageviews',

    'links.no_data' => 'There are no links created',
    'links.no_data_help' => 'Start by creating your first link.',

    'links.auto_copy_link.success' => 'Link has been copied to your clipboard.',
    'links.auto_copy_link.error' => 'Link could not be copied to your clipboard.',


    'link_delete_modal.header' => 'Delete link',
    'link_delete_modal.subheader' => 'If you have this link associated with QR codes, your dynamic QR codes will not work anymore. This action cannot be undone.',


    'link_create.breadcrumb' => 'Create link',
    'link_create.title' => 'Create link',
    'link_create.menu' => 'Create link',
    'link_create.header' => 'Create a new link',


    'link_update.breadcrumb' => 'Edit link',
    'link_update.title' => 'Edit link - %s',


    'links_statistics.title' => 'Links statistics',
    'links_statistics.menu' => 'Links statistics',
    'links_statistics.breadcrumb' => 'Links statistics',
    'links_statistics.header' => 'Links statistics',


    'link_statistics.breadcrumb' => 'Statistics',
    'link_statistics.title' => 'Link statistics - %s',
    'link_statistics.menu' => 'Statistics',
    'link_statistics.header' => '%s statistics',
    'link_statistics.link' => 'Statistics',
    'link_statistics.pageviews' => 'Pageviews',
    'link_statistics.visitors' => 'Visitors',

    'link_statistics.overview' => 'Overview',
    'link_statistics.overview_help' => '',
    'link_statistics.entries' => 'Entries',
    'link_statistics.entries_help' => 'All the entries that have been logged in a compact list.',
    'link_statistics.latest' => 'Latest entries',
    'link_statistics.data_preview' => 'Data preview',
    'link_statistics.data_preview_info' => 'Widgets data is based on the last %s entries. Click View more to see all the widget data.',
    'link_statistics.continent_code_help' => 'Discover the continents that your visitors are from',
    'link_statistics.country_help' => 'Discover the countries that your visitors are from.',
    'link_statistics.country_from_continent_code' => 'Countries of %s',
    'link_statistics.city_name_from_country' => 'Cities of %s',
    'link_statistics.city_name_help' => 'Discover the cities that your visitors are from.',
    'link_statistics.os' => 'Operating systems',
    'link_statistics.os_help' => 'Discover the operating systems that your visitors are using.',
    'link_statistics.browser' => 'Browsers',
    'link_statistics.browser_help' => 'Discover the browsers that your visitors are using.',
    'link_statistics.language' => 'Languages',
    'link_statistics.language_help' => 'Discover the browser languages that your visitors are having.',
    'link_statistics.device' => 'Devices',
    'link_statistics.device_help' => 'Discover the devices that your visitors are using.',
    'link_statistics.referrer_host' => 'Referrers',
    'link_statistics.referrer_path' => '%s referrer paths',
    'link_statistics.referrer_help' => 'Discover where your traffic is coming from.',
    'link_statistics.referrer_direct' => 'Direct',
    'link_statistics.referrer_qr' => 'QR code',
    'link_statistics.utms' => 'UTMs',
    'link_statistics.utms_help' => 'Discover how your UTM marketing campaigns are performing.',
    'link_statistics.utm_medium' => '%s utm mediums',
    'link_statistics.utm_campaign' => '%s / %s utm sources',
    'link_statistics.hour' => 'Visit hours',
    'link_statistics.hour_help' => 'Discover at what hours of the day your visitors are most active.',
    'link_statistics.table.os' => 'OS',
    'link_statistics.table.device' => 'Device',
    'link_statistics.table.browser' => 'Browser',
    'link_statistics.table.referrer' => 'Referrer',
    'link_statistics.no_data' => 'There are no statistics available for this date range',
    'link_statistics.no_data_help' => 'Wait for new traffic or change your date range.',


    'domains.breadcrumb' => 'Custom domains',
    'domains.title' => 'Custom domains',
    'domains.menu' => 'Custom domains',
    'domains.header' => 'Custom domains',
    'domains.subheader' => 'Here you can add your own custom domain to use with your dynamic QR code links.',
    'domains.create' => 'Connect domain',
    'domains.domain_id' => 'Domain',

    'domains.table.host' => 'Domain',
    'domains.table.is_enabled_pending' => 'Pending',
    'domains.table.is_enabled_active' => 'Active',

    'domains.help' => 'Your domain or subdomain must have an A record pointing to %1$s or CNAME record pointing to %2$s.',
    'domains.host' => 'Domain or subdomain',
    'domains.custom_index_url' => 'Custom index URL',
    'domains.custom_index_url_help' => 'Redirect to a specific URL when visitors land on the index of the domain.',
    'domains.custom_not_found_url' => 'Custom 404 not found URL',
    'domains.custom_not_found_url_help' => 'Redirect to a specific URL when visitors land on a not found page of the domain.',
    'domains.no_data' => 'There are no custom domains added',
    'domains.no_data_help' => 'Start by linking your first custom domain.',
    'domains.error_message.host_exists' => 'This custom domain already exists.',


    'domain_create.breadcrumb' => 'Connect custom domain',
    'domain_create.title' => 'Connect custom domain',
    'domain_create.menu' => 'Connect custom domain',
    'domain_create.header' => 'Connect custom domain',
    'domain_create.success_message' => 'Your custom domain has been submitted for approval and processing.',


    'domain_update.breadcrumb' => 'Edit custom domain',
    'domain_update.title' => 'Edit custom domain',
    'domain_update.menu' => 'Edit custom domain',
    'domain_update.header' => 'Edit custom domain',
    'domain_update.success_message' => 'Your custom domain update has been submitted for approval and processing.',


    'domain_delete_modal.header' => 'Delete domain',
    'domain_delete_modal.subheader' => 'By deleting the domain, all the data associated with the domain will be lost, including all the links associated with it. This action cannot be undone.',


    'projects.title' => 'Projects',
    'projects.menu' => 'Projects',
    'projects.breadcrumb' => 'Projects',
    'projects.header' => 'Projects',
    'projects.subheader' => 'The easiest way to categorize your resources.',
    'projects.create' => 'Create project',
    'projects.project_id' => 'Project',
    'projects.project_id_help' => 'A project will help you categorize your resources.',
    'projects.color' => 'Color',
    'projects.color_help' => 'The color is used to help differentiate projects.',
    'projects.no_data' => 'There are no projects for now',
    'projects.no_data_help' => 'Start by creating your first project.',


    'project_create.breadcrumb' => 'Create a new project',
    'project_create.title' => 'Create a new project',
    'project_create.header' => 'Create a new project',


    'project_update.breadcrumb' => 'Edit project',
    'project_update.title' => 'Edit project',
    'project_update.header' => 'Edit project',


    'pixels.title' => 'Pixels',
    'pixels.menu' => 'Pixels',
    'pixels.breadcrumb' => 'Pixels',
    'pixels.header' => 'Pixels',
    'pixels.subheader' => 'Tracking pixels collect visitor data and send it to pixel tracking websites, aiding in analytics and retargeting through conversion tracking.',
    'pixels.create' => 'Create pixel',
    'pixels.pixel_id' => 'Pixel',
    'pixels.pixel' => 'Pixel ID',
    'pixels.pixel_help' => 'Enter the pixel id from this specific pixel type you chose.',

    'pixels.no_data' => 'There are no pixels for now',
    'pixels.no_data_help' => 'Start by creating your first pixel.',


    'pixel_create.breadcrumb' => 'Create a new pixel',
    'pixel_create.title' => 'Create a new pixel',
    'pixel_create.header' => 'Create a new pixel',


    'pixel_update.breadcrumb' => 'Edit pixel',
    'pixel_update.title' => 'Edit pixel',
    'pixel_update.header' => 'Edit pixel',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',
    'pages.no_data' => 'There are resources yet',
    'pages.no_data_help' => 'We still got some work to do for our resources section',


    'blog.title' => 'Blog',
    'blog.title_search' => 'Search for \'%s\' - Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.header_search' => 'Blog - Search for \'%s\'',
    'blog.subheader' => 'Discover insights through our curated blog posts.',
    'blog.rss' => 'RSS Feed',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',
    'blog.rating' => '%1$s of %2$s ratings',
    'blog.no_data' => 'There are no blog posts yet',
    'blog.no_data_help' => 'We still got some writing to do for our blog post',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.menu' => 'Pricing',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew or change your plan',
    'plan.subheader_renew' => 'Select one plan to renew or change your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one package to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.quarterly' => 'Quarterly',
    'plan.custom_plan.biannual' => 'Biannual',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plans.choose' => 'Choose plan',
    'plans.renew' => 'Renew plan',
    'plans.trial' => 'Try for %s days',
    'plans.contact' => 'Contact us',
    'plans.lifetime' => 'Lifetime',

    'plan.why.header' => 'Why us?',
    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team is here to assist with any questions about our service.',
    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'You control all the data that you bring within your account on our website.',
    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We aim to give you the best experience because we know your time is valuable.',

    'plan.faq.header' => 'Frequently asked questions',
    'plan.faq.one.question' => 'What forms of payment do you accept?',
    'plan.faq.one.answer' => 'We accept payments via credit cards, PayPal & crypto as well.',
    'plan.faq.two.question' => 'Can I cancel my subscription?',
    'plan.faq.two.answer' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',
    'plan.faq.three.question' => 'Will I get an invoice?',
    'plan.faq.three.answer' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',
    'plan.faq.four.question' => 'Can I have a refund?',
    'plan.faq.four.answer' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',


    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',


    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.attention_title' => '✨Checkout ready 🔥',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.klarna' => 'Klarna',
	'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.iyzico' => 'Iyzico',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.paddle_billing' => 'Paddle',
    'pay.custom_plan.mercadopago' => 'MercadoPago',
    'pay.custom_plan.midtrans' => 'Midtrans',
    'pay.custom_plan.flutterwave' => 'Flutterwave',
    'pay.custom_plan.lemonsqueezy' => 'Lemonsqueezy',
    'pay.custom_plan.myfatoorah' => 'Myfatoorah',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly payments',
    'pay.custom_plan.quarterly' => 'Quarterly payments',
    'pay.custom_plan.biannual' => 'Biannual payments',
    'pay.custom_plan.annual' => 'Annual payments',
    'pay.custom_plan.savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'Use discount code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One time payment',
    'pay.custom_plan.recurring_type' => 'Recurring payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.quarterly' => 'Quarterly',
    'pay.custom_plan.summary.quarterly_help' => 'Every 90 days',
    'pay.custom_plan.summary.biannual' => 'Biannual',
    'pay.custom_plan.summary.biannual_help' => 'Every 180 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid.',
    'pay.error_message.code_used' => 'You have already used this code.',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade plan',
    'account.plan.renew_plan' => 'Renew or change plan',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Main settings of your account.',
    'account.settings.avatar' => 'Avatar',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',
    'account.settings.is_newsletter_subscribed' => 'Newsletter subscribed',
    'account.settings.is_newsletter_subscribed_help' => 'Receive a few emails per month with updates & discount campaigns we may run. We won\'t spam you.',
    'account.settings.referral_key' => 'Referral key',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.state' => 'State',
    'account.billing.county' => 'County',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',
    'account.billing.notes' => 'Additional notes',
    'account.billing.notes_help' => 'Here you can write additional data that you want to have on your invoices.',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.current_password_help' => 'If you do not know your current password, you mut logout and use the lost password functionality to reset it.',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open your authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the QR code using your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Copy the following secret code into your app for a manual setup.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid.',
    'account.error_message.referral_key_exists' => 'This referral key is already in use.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_preferences.title' => 'Preferences',
    'account_preferences.menu' => 'Preferences',
    'account_preferences.header' => 'Preferences',
    'account_preferences.subheader' => 'Here you can set different preferences for your account related to the site usage.',
    'account_preferences.success_message' => 'Your account preferences have been updated.',
    'account_preferences.avatar' => 'Avatar',
    'account_preferences.tracking_settings' => 'Tracking settings',
    'account_preferences.excluded_ips' => 'Excluded IPs',
    'account_preferences.excluded_ips_help' => 'Exclude IPs from being tracked. Comma separated values.',
    'account_preferences.default_settings' => 'Default settings',
    'account_preferences.default_results_per_page' => 'Default results per page',
    'account_preferences.default_order_type' => 'Default results order',
    'account_preferences.default_order_by_x' => '%s default order by',
    'account_preferences.white_labeling' => 'White labeling settings',
    'account_preferences.white_label_title' => 'White label title',
    'account_preferences.white_label_logo_light' => 'White label logo light',
    'account_preferences.white_label_logo_dark' => 'White label logo dark',
    'account_preferences.white_label_favicon' => 'White label favicon',
    'account_preferences.dashboard' => 'Dashboard settings',
    'account_preferences.dashboard_features' => 'Dashboard features',
    'account_preferences.links_auto_copy_link' => 'Auto copy link after it is created',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.success_message_lifetime' => 'You redeemed the %2$s plan for lifetime.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'account_plan.title' => 'Account plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => '%s plan',
    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',
    'account_plan.plan.lifetime' => 'Plan is for lifetime, it does not expire.',
    'account_plan.cancel.header' => 'Cancel subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',
    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',
    'account_plan.upgrade.header' => 'Upgrade',
    'account_plan.upgrade.header_discount' => 'Upgrade for %s off',
    'account_plan.upgrade.subheader' => 'In need of more? Choose the %s plan.',
    'account_plan.upgrade.discount_button' => 'Checkout at %s off',


    'account_payments.title' => 'Account payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payment_processor' => 'Processor',
    'account_payments.total_amount' => 'Total amount',
    'account_payments.plan_id' => 'Plan',
    'account_payments.invoice' => 'Invoice',
    'account_payments.status_pending' => 'Pending',
    'account_payments.status_approved' => 'Approved',
    'account_payments.no_data' => 'No payments found',

    'account_payments.processor' => 'Processor',
    'account_payments.type_one_time' => 'One time',
    'account_payments.type_recurring' => 'Recurring',
    'account_payments.frequency' => 'Frequency',
    'account_payments.order_by_total_amount' => 'Total amount',

    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.no_data' => 'Your account has no recorded logs',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'Teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.table.members' => 'Members',
    'teams.team' => 'Team',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.access' => '%s permissions',
    'team_members.access.read' => 'View',
    'team_members.access.create' => 'Create',
    'team_members.access.update' => 'Update',
    'team_members.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams\' member',
    'teams_member.menu' => 'Teams\' member',
    'teams_member.breadcrumb' => 'Teams\' member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'sso.menu' => 'Go to %s',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'Invoice',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.item' => 'Item',
    'invoice.amount' => 'Amount',
    'invoice.plan' => '%s Plan',
    'invoice.frequency' => '%s access.',
    'invoice.frequency.monthly' => '30 days',
    'invoice.frequency.quarterly' => '90 days',
    'invoice.frequency.biannual' => '180 days',
    'invoice.frequency.annual' => '1 year',
    'invoice.frequency.lifetime' => 'Lifetime',
    'invoice.code' => 'Discount',
    'invoice.code_help' => 'Code used: %s',
    'invoice.total' => 'Total',
    'invoice.paid_via' => 'Paid via %s',


    'maintenance.title' => 'Maintenance mode',
    'maintenance.header' => 'Maintenance mode',
    'maintenance.subheader' => 'We are doing some maintenance work, we\'ll be back soon.',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',

    'login.twofa_token' => 'Two-factor token',
    'login.remember_me' => 'Remember me',
    'login.remember_me_help' => 'A browser cookie will be used to remember you for %s days on this browser.',
    'login.login' => 'Login',
    'login.verify' => 'Verify',

    'login.register' => 'Don\'t have an account? %s',
    'login.register_help' => 'Register',
    'login.lost_password' => 'Lost password',
    'login.resend_activation' => 'Resend activation',
    'login.facebook' => 'Sign in with Facebook',
    'login.google' => 'Sign in with Google',
    'login.twitter' => 'Sign in with X',
    'login.discord' => 'Sign in with Discord',
    'login.linkedin' => 'Sign in with LinkedIn',
    'login.microsoft' => 'Sign in with Microsoft',

    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve emailed you the password reset link.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve emailed you the activation link.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',
    'register.repeat_password' => 'Repeat Password',
    'register.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.is_newsletter_subscribed' => 'I agree receive a few emails per month from the newsletter. You can unsubscribe at any time.',
    'register.register' => 'Register',
    'register.login' => 'Already have an account? %s',
    'register.login_help' => 'Sign in',
    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.email_aliases_not_allowed' => 'Email aliases are not allowed.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.error_message.blacklisted_ip' => 'Your IP has been blacklisted.',
    'register.success_message.registration' => 'We\'ve emailed you the activation link.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.ai_qr_codes.header' => 'Latest AI QR codes',
    'dashboard.qr_codes.header' => 'Latest QR codes',
    'dashboard.barcodes.header' => 'Latest barcodes',
    'dashboard.links.header' => 'Latest links',
    'dashboard.total_qr_codes' => '%s QR codes',
    'dashboard.total_links' => '%s links',
    'dashboard.total_barcodes' => '%s barcodes',
    'dashboard.total_ai_qr_codes' => '%s AI QR this month',
    'dashboard.total_domains' => '%s domains',
    'dashboard.total_projects' => '%s projects',

    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',
    'index.title' => 'QR code generator',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => 'QR Code Generator',
    'index.subheader' => 'Generate simple & advanced QR codes. Easy, customizable & trackable.',
    'index.qr' => 'Generate QR codes',
    'index.barcode' => 'Generate barcodes',
    'index.register' => 'Sign up',
    'index.hero_image_alt' => 'Screenshot of app dashboard',
    'index.static_qr_image_alt' => 'Screenshot of the QR code generator page',
    'index.dynamic_qr_image_alt' => 'Screenshot of the QR code analytics page',

    'index.qr_templates.header' => 'QR templates',
    'index.qr_templates.subheader' => 'You get %s built-in QR code templates to get you started right away.',

    'index.privacy.header' => 'Privacy',
    'index.privacy.subheader' => 'We only store QR code data that you voluntarily save in your account.',

    'index.customization.header' => 'Highly customizable',
    'index.customization.subheader' => 'Create the QR code you need, brand it with your own colors & logos.',

    'index.short_urls.header' => 'Shortened URLs',
    'index.short_urls.subheader' => 'We also provide a simple, yet powerful URL shortener service.',

    'index.pixels.header' => 'Tracking pixels',
    'index.pixels.subheader' => 'All the links easily integrate with any of the following pixel providers.',

    'index.domains.header' => 'Custom domains',
    'index.domains.subheader' => 'Connect your own domain or use our predefined ones.',

    'index.projects.header' => 'Projects',
    'index.projects.subheader' => 'Easiest way to categorize your managed resources.',

    'index.shortener_app_linking.header' => 'URLs that open apps automatically',
    'index.shortener_app_linking.subheader' => 'Short links that automatically detect the used app and open it on mobile.',

    'index.pricing.header' => 'Simple, transparent pricing.',
    'index.pricing.subheader' => 'Choose the plan that is right for you and your budget.',

    'index.static.header' => 'Static QR codes',
    'index.static.subheader' => 'Static QR codes are permanent, with all data embedded directly into the code. Once created and printed, the information cannot be modified.',
    'index.static.feature1' => 'Fully customizable',
    'index.static.feature2' => 'No scan limit',
    'index.static.feature3' => 'No data saved on our servers',

    'index.dynamic.header' => 'Dynamic QR codes',
    'index.dynamic.subheader' => 'Dynamic QR codes let you update the destination at any time. This flexibility is powered by our Links tool, which integrates various technologies to make the process seamless.',
    'index.dynamic.feature1' => 'Advanced scan statistics',
    'index.dynamic.feature2' => 'Change URL destination dynamically',
    'index.dynamic.feature3' => 'Scheduling, expiration limits, A/B Rotation',
    'index.dynamic.feature4' => 'Password protection',
    'index.dynamic.feature5' => 'Country, device & language re-targeting',

    'index.ai_qr_codes.header' => 'AI QR Codes',
    'index.ai_qr_codes.alt' => 'AI Qr code example nr #%s',

    'index.qr_codes.header' => 'A handful of QR code templates',
    'index.qr_codes.subheader' => 'Get started with the most in-demand and used QR code templates.',
    'index.qr_codes.choose' => 'Generate %s QR code',

    'index.barcodes.header' => 'Barcode generator system',
    'index.barcodes.subheader' => 'We\'ve got it all. Use our barcodes system to easily generate barcodes.',
    'index.barcodes.choose' => 'Generate %s barcode',

    'index.api.name' => 'API system ',
    'index.api.header' => 'Developer ready',
    'index.api.subheader' => 'Fully featured & easy to use API system for developers.',

    'index.cta.header' => 'Get started',
    'index.cta.subheader' => 'Super easy & highly customizable static or dynamic QR codes.',
    'index.cta.pricing' => 'Pricing',
    'index.cta.register' => 'Sign up',

    'index.blog.header' => 'Latest %1$sblog%2$s posts',

    'index.testimonials.header' => 'Why people love us',
    'index.testimonials.one.text' => 'This platform completely transformed the way we manage our workflows. It’s intuitive, fast, and has saved our team countless hours every week.',
    'index.testimonials.one.name' => 'Andrea Wilson',
    'index.testimonials.one.attribute' => 'Editor, Writer\'s Weekly',
    'index.testimonials.two.text' => 'I was skeptical at first, but within days, I saw how much more productive our team became. The support team is also incredibly responsive.',
    'index.testimonials.two.name' => 'George Parker',
    'index.testimonials.two.attribute' => 'Founder, BrightPath Solutions',
    'index.testimonials.three.text' => 'We’ve tried multiple tools before, but nothing comes close to this. The onboarding was smooth, and our entire team was up and running in no time.',
    'index.testimonials.three.name' => 'Calvin Mitchell',
    'index.testimonials.three.attribute' => 'CEO, FlowWorks Inc.',

    'index.faq.header' => '<span class="text-primary">Answer</span> for your common <span class="text-primary">question</span>',
    'index.faq.one.question' => 'How do I get started?',
    'index.faq.one.answer' => 'Simply sign up for an account and follow the onboarding steps. You’ll be ready to use the platform in just a few minutes.',
    'index.faq.two.question' => 'Do you offer customer support?',
    'index.faq.two.answer' => 'Yes, our support team is available 24/7 via email and live chat. We aim to respond to all inquiries within a few hours.',
    'index.faq.three.question' => 'Is my data secure?',
    'index.faq.three.answer' => 'We take data security seriously. All information is encrypted and backed up regularly to ensure your data is safe and protected.',
    'index.faq.four.question' => 'Will I need technical skills to use this?',
    'index.faq.four.answer' => 'Not at all. Our platform is designed to be user-friendly, with no coding required to get started.',
    'index.faq.five.question' => 'What makes this different from other tools?',
    'index.faq.five.answer' => 'We focus on simplicity and performance. Our platform is lightweight, easy to use, and designed to help you achieve results faster.',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.title_dynamic' => '%s - API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',
    'api_documentation.allowed_values' => 'Allowed values: %s',
    'api_documentation.available_when' => 'Available when: %s',
    'api_documentation.timezone_info' => 'All API endpoint results work with the <strong>%s timezone</strong> unless specified otherwise.',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.team_members' => 'Team members',
    'api_documentation.teams_member' => 'Teams\' member',
    'api_documentation.user' => 'User',

    'api_documentation.links' => 'Links',
    'api_documentation.links.url' => 'The URL alias of the generated link. Leave empty for a randomly generated one.',
    'api_documentation.links.location_url' => 'The URL of the destination.',

    'api_documentation.statistics' => 'Link statistics',
    'api_documentation.statistics.start_date' => 'Start date in <code>Y-m-d</code> format.',
    'api_documentation.statistics.end_date' => 'End date in <code>Y-m-d</code> format.',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us.',
    'contact.email' => 'Email address',
    'contact.name' => 'Full name',
    'contact.subject' => 'Subject',
    'contact.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'internal_notifications.breadcrumb' => 'Notifications',
    'internal_notifications.title' => 'Notifications',
    'internal_notifications.menu' => 'Notifications',
    'internal_notifications.header' => 'Notifications',
    'internal_notifications.subheader' => 'All your recent account related notifications.',
    'internal_notifications.no_data' => 'No notifications available',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',

    'not_found.title' => 'Not found',
    'not_found.header' => 'Page not found',
    'not_found.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'not_found.button' => 'Go back home',
];
